using System;
using System.Net;
using System.Text;
using System.IO;
using Newtonsoft.Json;
using System.Collections.Generic;
using Newtonsoft.Json.Linq;

namespace booklist
{
    class Program
    {

        class PhoneBook
        {
            public string title { get; set; }
            public string id { get; set; }

        }
        static void Main(string[] args)
        {
           
            WebRequest request = WebRequest.Create("http://ippanel.com/services.jspd");
            request.Method = "POST";
            string postData = "op=booklist&uname=USERNAME&pass=PASSWORD";
            byte[] byteArray = Encoding.UTF8.GetBytes(postData);
            request.ContentType = "application/x-www-form-urlencoded";
            request.ContentLength = byteArray.Length;
            Stream dataStream = request.GetRequestStream();
            dataStream.Write(byteArray, 0, byteArray.Length);
            dataStream.Close();
            WebResponse response = request.GetResponse();
            Console.WriteLine(((HttpWebResponse)response).StatusDescription);
            dataStream = response.GetResponseStream();
            StreamReader reader = new StreamReader(dataStream);
            string responseFromServer = reader.ReadToEnd();
            List<string> phone = JsonConvert.DeserializeObject<List<string>>(responseFromServer);
            var val = phone.ToArray();
            var jsonResult = val[1];
            List<PhoneBook> results =  JsonConvert.DeserializeObject<List<PhoneBook>>(jsonResult);

            foreach(var phonebook in results){
                Console.WriteLine("PhoneBook ID: "+phonebook.id + " and PhoneBook Title: " +phonebook.title);
            }

            Console.WriteLine(results);
            reader.Close();
            dataStream.Close();
            response.Close();
            System.Diagnostics.Debug.WriteLine(responseFromServer);
        }
    }
}