<?php
 if ( !class_exists('Puc_v4p6_Vcs_GitHubApi', false) ): class Puc_v4p6_Vcs_GitHubApi extends Puc_v4p6_Vcs_Api { protected $userName; protected $repositoryName; protected $repositoryUrl; protected $accessToken; protected $releaseAssetsEnabled = false; protected $assetFilterRegex = null; protected $assetApiBaseUrl = null; public function __construct($repositoryUrl, $accessToken = null) { $path = @parse_url($repositoryUrl, PHP_URL_PATH); if ( preg_match('@^/?(?P<username>[^/]+?)/(?P<repository>[^/#?&]+?)/?$@', $path, $matches) ) { $this->userName = $matches['username']; $this->repositoryName = $matches['repository']; } else { throw new InvalidArgumentException('Invalid GitHub repository URL: "' . $repositoryUrl . '"'); } parent::__construct($repositoryUrl, $accessToken); } public function getLatestRelease() { $release = $this->api('/repos/:user/:repo/releases/latest'); if ( is_wp_error($release) || !is_object($release) || !isset($release->tag_name) ) { return null; } $reference = new Puc_v4p6_Vcs_Reference(array( 'name' => $release->tag_name, 'version' => ltrim($release->tag_name, 'v'), 'downloadUrl' => $this->signDownloadUrl($release->zipball_url), 'updated' => $release->created_at, 'apiResponse' => $release, )); if ( isset($release->assets[0]) ) { $reference->downloadCount = $release->assets[0]->download_count; } if ( $this->releaseAssetsEnabled && isset($release->assets, $release->assets[0]) ) { $matchingAssets = array_filter($release->assets, array($this, 'matchesAssetFilter')); if ( !empty($matchingAssets) ) { if ( $this->isAuthenticationEnabled() ) { $reference->downloadUrl = $this->signDownloadUrl($matchingAssets[0]->url); } else { $reference->downloadUrl = $matchingAssets[0]->browser_download_url; } $reference->downloadCount = $matchingAssets[0]->download_count; } } if ( !empty($release->body) ) { $reference->changelog = Parsedown::instance()->text($release->body); } return $reference; } public function getLatestTag() { $tags = $this->api('/repos/:user/:repo/tags'); if ( is_wp_error($tags) || empty($tags) || !is_array($tags) ) { return null; } $versionTags = $this->sortTagsByVersion($tags); if ( empty($versionTags) ) { return null; } $tag = $versionTags[0]; return new Puc_v4p6_Vcs_Reference(array( 'name' => $tag->name, 'version' => ltrim($tag->name, 'v'), 'downloadUrl' => $this->signDownloadUrl($tag->zipball_url), 'apiResponse' => $tag, )); } public function getBranch($branchName) { $branch = $this->api('/repos/:user/:repo/branches/' . $branchName); if ( is_wp_error($branch) || empty($branch) ) { return null; } $reference = new Puc_v4p6_Vcs_Reference(array( 'name' => $branch->name, 'downloadUrl' => $this->buildArchiveDownloadUrl($branch->name), 'apiResponse' => $branch, )); if ( isset($branch->commit, $branch->commit->commit, $branch->commit->commit->author->date) ) { $reference->updated = $branch->commit->commit->author->date; } return $reference; } public function getLatestCommit($filename, $ref = 'master') { $commits = $this->api( '/repos/:user/:repo/commits', array( 'path' => $filename, 'sha' => $ref, ) ); if ( !is_wp_error($commits) && is_array($commits) && isset($commits[0]) ) { return $commits[0]; } return null; } public function getLatestCommitTime($ref) { $commits = $this->api('/repos/:user/:repo/commits', array('sha' => $ref)); if ( !is_wp_error($commits) && is_array($commits) && isset($commits[0]) ) { return $commits[0]->commit->author->date; } return null; } protected function api($url, $queryParams = array()) { $baseUrl = $url; $url = $this->buildApiUrl($url, $queryParams); $options = array('timeout' => 10); if ( !empty($this->httpFilterName) ) { $options = apply_filters($this->httpFilterName, $options); } $response = wp_remote_get($url, $options); if ( is_wp_error($response) ) { do_action('puc_api_error', $response, null, $url, $this->slug); return $response; } $code = wp_remote_retrieve_response_code($response); $body = wp_remote_retrieve_body($response); if ( $code === 200 ) { $document = json_decode($body); return $document; } $error = new WP_Error( 'puc-github-http-error', sprintf('GitHub API error. Base URL: "%s",  HTTP status code: %d.', $baseUrl, $code) ); do_action('puc_api_error', $error, $response, $url, $this->slug); return $error; } protected function buildApiUrl($url, $queryParams) { $variables = array( 'user' => $this->userName, 'repo' => $this->repositoryName, ); foreach ($variables as $name => $value) { $url = str_replace('/:' . $name, '/' . urlencode($value), $url); } $url = 'https://api.github.com' . $url; if ( !empty($this->accessToken) ) { $queryParams['access_token'] = $this->accessToken; } if ( !empty($queryParams) ) { $url = add_query_arg($queryParams, $url); } return $url; } public function getRemoteFile($path, $ref = 'master') { $apiUrl = '/repos/:user/:repo/contents/' . $path; $response = $this->api($apiUrl, array('ref' => $ref)); if ( is_wp_error($response) || !isset($response->content) || ($response->encoding !== 'base64') ) { return null; } return base64_decode($response->content); } public function buildArchiveDownloadUrl($ref = 'master') { $url = sprintf( 'https://api.github.com/repos/%1$s/%2$s/zipball/%3$s', urlencode($this->userName), urlencode($this->repositoryName), urlencode($ref) ); if ( !empty($this->accessToken) ) { $url = $this->signDownloadUrl($url); } return $url; } public function getTag($tagName) { throw new LogicException('The ' . __METHOD__ . ' method is not implemented and should not be used.'); } public function setAuthentication($credentials) { parent::setAuthentication($credentials); $this->accessToken = is_string($credentials) ? $credentials : null; } public function chooseReference($configBranch) { $updateSource = null; if ( $configBranch === 'master' ) { $updateSource = $this->getLatestRelease(); if ( $updateSource === null ) { $updateSource = $this->getLatestTag(); } } if ( empty($updateSource) ) { $updateSource = $this->getBranch($configBranch); } return $updateSource; } public function signDownloadUrl($url) { if ( empty($this->credentials) ) { return $url; } return add_query_arg('access_token', $this->credentials, $url); } public function enableReleaseAssets($fileNameRegex = null) { $this->releaseAssetsEnabled = true; $this->assetFilterRegex = $fileNameRegex; $this->assetApiBaseUrl = sprintf( '//api.github.com/repos/%1$s/%2$s/releases/assets/', $this->userName, $this->repositoryName ); add_filter('upgrader_pre_download', array($this, 'addHttpRequestFilter'), 10, 1); } protected function matchesAssetFilter($releaseAsset) { if ( $this->assetFilterRegex === null ) { return true; } return isset($releaseAsset->name) && preg_match($this->assetFilterRegex, $releaseAsset->name); } public function addHttpRequestFilter($result) { static $filterAdded = false; if ( $this->releaseAssetsEnabled && !$filterAdded && $this->isAuthenticationEnabled() ) { add_filter('http_request_args', array($this, 'setReleaseDownloadHeader'), 10, 2); $filterAdded = true; } return $result; } public function setReleaseDownloadHeader($requestArgs, $url = '') { if ( strpos($url, $this->assetApiBaseUrl) !== false ) { $requestArgs['headers']['accept'] = 'application/octet-stream'; } return $requestArgs; } } endif;