<?php
if ( !class_exists('Puc_v4p6_Scheduler', false) ): class Puc_v4p6_Scheduler { public $checkPeriod = 12; public $throttleRedundantChecks = false; public $throttledCheckPeriod = 72; protected $hourlyCheckHooks = array('load-update.php'); protected $updateChecker; private $cronHook = null; public function __construct($updateChecker, $checkPeriod, $hourlyHooks = array('load-plugins.php')) { $this->updateChecker = $updateChecker; $this->checkPeriod = $checkPeriod; $this->cronHook = $this->updateChecker->getUniqueName('cron_check_updates'); if ( $this->checkPeriod > 0 ){ $defaultSchedules = array( 1 => 'hourly', 12 => 'twicedaily', 24 => 'daily', ); if ( array_key_exists($this->checkPeriod, $defaultSchedules) ) { $scheduleName = $defaultSchedules[$this->checkPeriod]; } else { $scheduleName = 'every' . $this->checkPeriod . 'hours'; add_filter('cron_schedules', array($this, '_addCustomSchedule')); } if ( !wp_next_scheduled($this->cronHook) && !defined('WP_INSTALLING') ) { wp_schedule_event(time(), $scheduleName, $this->cronHook); } add_action($this->cronHook, array($this, 'maybeCheckForUpdates')); add_action( 'admin_init', array($this, 'maybeCheckForUpdates') ); add_action('load-update-core.php', array($this, 'maybeCheckForUpdates')); $this->hourlyCheckHooks = array_merge($this->hourlyCheckHooks, $hourlyHooks); foreach($this->hourlyCheckHooks as $hook) { add_action($hook, array($this, 'maybeCheckForUpdates')); } add_action('upgrader_process_complete', array($this, 'upgraderProcessComplete'), 11, 2); } else { wp_clear_scheduled_hook($this->cronHook); } } public function upgraderProcessComplete( $upgrader, $upgradeInfo ) { if ( !is_array($upgradeInfo) || !isset($upgradeInfo['type'], $upgradeInfo['action']) || 'update' !== $upgradeInfo['action'] || !in_array($upgradeInfo['type'], array('plugin', 'theme')) ) { return; } if ( is_a($this->updateChecker, 'Puc_v4p6_Theme_UpdateChecker') ) { if ( 'theme' !== $upgradeInfo['type'] || !isset($upgradeInfo['themes']) ) { return; } if ( !in_array( strtolower($this->updateChecker->directoryName), array_map('strtolower', $upgradeInfo['themes']) ) ) { return; } } if ( is_a($this->updateChecker, 'Puc_v4p6_Plugin_UpdateChecker') ) { if ( 'plugin' !== $upgradeInfo['type'] || !isset($upgradeInfo['plugins']) ) { return; } if ( !in_array( strtolower($this->updateChecker->directoryName), array_map('dirname', array_map('strtolower', $upgradeInfo['plugins'])) ) ) { return; } } $this->maybeCheckForUpdates(); } public function maybeCheckForUpdates() { if ( empty($this->checkPeriod) ){ return; } $state = $this->updateChecker->getUpdateState(); $shouldCheck = ($state->timeSinceLastCheck() >= $this->getEffectiveCheckPeriod()); $shouldCheck = apply_filters( $this->updateChecker->getUniqueName('check_now'), $shouldCheck, $state->getLastCheck(), $this->checkPeriod ); if ( $shouldCheck ) { $this->updateChecker->checkForUpdates(); } } protected function getEffectiveCheckPeriod() { $currentFilter = current_filter(); if ( in_array($currentFilter, array('load-update-core.php', 'upgrader_process_complete')) ) { $period = 60; } else if ( in_array($currentFilter, $this->hourlyCheckHooks) ) { $period = 3600; } else if ( $this->throttleRedundantChecks && ($this->updateChecker->getUpdate() !== null) ) { $period = $this->throttledCheckPeriod * 3600; } else if ( defined('DOING_CRON') && constant('DOING_CRON') ) { $cronFuzziness = 20 * 60; $period = $this->checkPeriod * 3600 - $cronFuzziness; } else { $period = $this->checkPeriod * 3600; } return $period; } public function _addCustomSchedule($schedules) { if ( $this->checkPeriod && ($this->checkPeriod > 0) ){ $scheduleName = 'every' . $this->checkPeriod . 'hours'; $schedules[$scheduleName] = array( 'interval' => $this->checkPeriod * 3600, 'display' => sprintf('Every %d hours', $this->checkPeriod), ); } return $schedules; } public function removeUpdaterCron() { wp_clear_scheduled_hook($this->cronHook); } public function getCronHookName() { return $this->cronHook; } } endif; 